DROP PROCEDURE [hips].[PatientMasterIhiInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 17 April 2012
-- Description:   Inserts a new record into the PatientMasterIhi Table
-- Modified:
-- 30 Jul 2012 - Andrew - Added additional fields
-- 19 Dec 2012 - Simon  - Removed PcehrAdvertised and AccessCodeRequiredId
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterIhiInsert] 
(
	  @PatientMasterId INT
	, @Ihi VARCHAR(50) = NULL
	, @IhiStatusId INT
	, @IhiRecordStatusId INT
	, @RegisteredFamilyName VARCHAR(80)
	, @RegisteredGivenName VARCHAR(80)
	, @RegisteredSexId INT
	, @DateLastValidated DATETIME
	, @UserModified VARCHAR(256)
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int

    SET @intErrorCode = 0

    INSERT
     INTO [hips].[PatientMasterIhi]
         ( [PatientMasterId]
         , [Ihi]
         , [IhiStatusId]
		 , [IhiRecordStatusId]
		 , [RegisteredFamilyName]
		 , [RegisteredGivenName]
		 , [RegisteredSexId]
         , [DateLastValidated]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         )
    VALUES
         ( @PatientMasterId
         , @Ihi
         , @IhiStatusId 
		 , @IhiRecordStatusId 
		 , @RegisteredFamilyName
		 , @RegisteredGivenName
		 , @RegisteredSexId 
         , @DateLastValidated
         , GETDATE()
         , @UserModified
         , GETDATE()
         , @UserModified
         )

    SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
        SELECT [PatientMasterId]
             , [Ihi]
             , [IhiStatusId]
			 , [IhiRecordStatusId]
			 , [RegisteredFamilyName]
			 , [RegisteredGivenName]
			 , [RegisteredSexId]
             , [DateLastValidated]
             , [DateCreated]
             , [UserCreated]
             , [DateModified]
             , [UserModified]
         FROM [hips].[PatientMasterIhi]
         WHERE [PatientMasterId] = @PatientMasterId
    END

    RETURN(@intErrorCode)
END
GO

